<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @package ExtraWatch  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @version 2.3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @revision 2663  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @copyright (C) 2016 by CodeGravity.com - All rights reserved!  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @website http://www.extrawatch.com  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 */

defined('_JEXEC') or die('Restricted access');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

class ExtraWatchUserHTML  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
{

  public $extraWatch;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  private $env;

  function __construct($extraWatch)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $this->extraWatch = $extraWatch;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->env = ExtraWatchEnvFactory::getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

	
	private function renderUserList($userLog) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		if (@$userLog) {
        $output = "<table border='0' class='table table-striped tablesorter'><thead><th>time</th><th>username</th><th>name</th><th>ip</th><th>country</th><th>action</th></thead><tbody>";
        if (@$userLog) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            foreach($userLog as $user) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
				$blockingActionOutput = "<a  id='".$user->ip."' href='" . $this->extraWatch->config->renderLink("antiSpam", "&action=toggleBlocking&ip=" . $user->ip) . "' onclick=\"return confirm('"._EW_USERS_BLOCK_IP_CONFIRM."');\"><img src='" .$this->extraWatch->config->getLiveSiteWithSuffix() . "components/com_extrawatch/img/icons/unpublished.png'/>&nbsp; ". _EW_GOALS_BLOCK . "</a>";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

			
				if (@!$user->countryCode) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
					$countryCode = $this->extraWatch->helper->countryByIp($user->ip);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
					$this->extraWatch->user->updateUserCountryByIp($user->ip, $countryCode);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
				} else {
					$countryCode = $user->countryCode;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
				}
				$countryName = $this->extraWatch->helper->countryCodeToCountryName($countryCode);


                $userName = $this->env->getUsernameById($user->userId);
                if (@$userName) {
                    $output .= "<tr>";
                    $output .= "<td width='20%'>".ExtraWatchDate::getDateTimeFromUTC($user->timestamp)."</td>";
                    $output .= "<td width='20%'>".$userName."</td>";
                    $userRealName = $this->env->getUserRealNameById($user->userId);
                    $output .= "<td width='20%'>".$userRealName."</td>";
                    $output .= "<td width='20%'>".$user->ip."</td>";
                    $output .= "<td width='20%'>";
                    if (@$countryCode) {
                        $output .= "<img src='".$this->extraWatch->config->getLiveSiteWithSuffix() . "components/com_extrawatch/img/flags/".$countryCode.".png' title='".$countryName."'/>";
                    }
                    $output .= "</td>";
                    $output .= "<td width='20%'>".$blockingActionOutput."</td>";
                    $output .= "</tr>";
                }
            }
        }

        $output .= "</tbody></table>";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		return $output;
		} else {
		return _EW_NO_DATA."<br/>";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		}
	
	}

    function renderUserLog() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $userLog = $this->extraWatch->user->getUserLog();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->renderUserList($userLog);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }


    function renderUsersSharingSameLogin() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $userLog = $this->extraWatch->user->getUsersSharingSameLogin();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->renderUserList($userLog);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }


	

}
