<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @package ExtraWatch  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @version 2.3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @revision 2663  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @copyright (C) 2016 by CodeGravity.com - All rights reserved!  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @website http://www.extrawatch.com  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 */

/** ensure this file is being included by a parent file */  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
defined('_JEXEC') or die('Restricted access');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

class ExtraWatchEnvSetupJoomla implements ExtraWatchEnvSetup  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
{

  public $env;
  public $database;

  function __construct()
  {
    $this->env = ExtraWatchEnvFactory::getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $mainframe = & JFactory :: getApplication('site');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $mainframe->initialise();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->database = & JFactory :: getDBO();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function install()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    if ("1.5" == "1.5" && !version_compare(JVERSION, '1.6.0', '<')) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      echo("<span style='color: red'><h2>Error: You are using joomla " . JVERSION . " but the installation package is for version 1.5 ! Uninstall this version, <a href='http://www.extrawatch.com/download'>Go to download section</a>, download the package for Joomla " . JVERSION . ", and install again.</h2></span>");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return -1;
    } elseif ("1.5" == "1.6" && !version_compare(JVERSION, '1.6.0', '>=')) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      echo("<span style='color: red'><h2>Error: You are using joomla " . JVERSION . " but the installation package is for version 1.5 ! Uninstall this version, <a href='http://www.extrawatch.com/download'>Go to download section</a>, download the package for Joomla " . JVERSION . ", and install again.</h2></span>");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return -1;
    }

    $i = 0;
    $numberOfFiles = 64;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    for ($j = 1; $j <= $numberOfFiles; $j++) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $fileName = JPATH_SITE . DS . "components" . DS . "com_extrawatch" . DS . "sql" . DS . "extrawatch-$j.sql";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $lines = file($fileName);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      if (!$lines) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        die("<span style='color: red'>Error reading file: $fileName, your joomla site path is set to: " . JPATH_SITE . " what is probably not correct, check configuration.php</span><br/>");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      }
      $query = "";
      foreach ($lines as $line_num => $line) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query .= trim($line);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (strstr($line, ");")) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          if ($j % 10 == 0)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            echo ((floor((($j) / $numberOfFiles) * 100)) . "%");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          else
            echo (".");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          $this->database->setQuery(trim($query));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          $result = $this->database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          if (!$result)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            echo ("Error: " + $this->database->getQuery());  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          flush();
          $query = "";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          $i++;
        }
        //	@ unlink($fileName); //try to delete  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      }
    }
    echo ("100%");
  }

  function uninstall()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    die("install triggered");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function activate()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $query = "UPDATE #__components SET admin_menu_img='../components/com_extrawatch/img/icons/extrawatch-logo-16x16.gif' WHERE admin_menu_link='option=com_extrawatch'";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->database->setQuery(trim($query));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    $query = "DELETE IGNORE FROM #__components where admin_menu_link like '%option=com_extrawatch%'  and admin_menu_img like '%../components/com_extrawatch/img/icons/%' and admin_menu_img<>'../components/com_extrawatch/img/icons/extrawatch-logo-16x16.png'";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->database->setQuery(trim($query));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    $query = sprintf("select id from #__components where `name` = '%s' limit 1", "ExtraWatch");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->database->setQuery(trim($query));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $id = $this->database->loadResult();


      $query = sprintf("INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Live Stats', 0, %d, 'option=com_extrawatch', 0, '../components/com_extrawatch/img/icons/map_icon.gif', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('SEO', 0, %d, 'option=com_extrawatch&task=seo', 1, '../components/com_extrawatch/img/icons/seo.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Clicks', 0, %d, 'option=com_extrawatch&task=heatmap', 2, '../components/com_extrawatch/img/icons/click.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Downloads', 0, %d, 'option=com_extrawatch&task=downloads', 3, '../components/com_extrawatch/img/icons/downloads.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Traffic Flow', 0, %d, 'option=com_extrawatch&task=flow', 4, '../components/com_extrawatch/img/icons/flow.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Graphs & Trends', 0, %d, 'option=com_extrawatch&task=graphs', 5, '../components/com_extrawatch/img/icons/trend_icon.gif', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Goals', 0, %d, 'option=com_extrawatch&task=goals', 6, '../components/com_extrawatch/img/icons/goal.gif', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Visit History', 0, %d, 'option=com_extrawatch&task=history', 7, '../components/com_extrawatch/img/icons/history.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Anti-spam & Blocking', 0, %d, 'option=com_extrawatch&task=antiSpam', 8, '../components/com_extrawatch/img/icons/antispam.gif', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Email Reports', 0, %d, 'option=com_extrawatch&task=emails', 9, '../components/com_extrawatch/img/icons/emails.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Your License', 0, %d, 'option=com_extrawatch&task=license', 10, '../components/com_extrawatch/img/icons/license.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Database Status', 0, %d, 'option=com_extrawatch&task=status', 11, '../components/com_extrawatch/img/icons/status.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Modules / Components Sizes', 0, %d, 'option=com_extrawatch&task=sizes', 12, '../components/com_extrawatch/img/icons/sizes.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Settings', 0, %d, 'option=com_extrawatch&task=settings', 13, '../components/com_extrawatch/img/icons/settings.gif', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) ('Update', 0, %d, 'option=com_extrawatch&task=update', 14, '../components/com_extrawatch/img/icons/update.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
      $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) ('Credits', 0, %d, 'option=com_extrawatch&task=credits', 15, '../components/com_extrawatch/img/icons/credits.png', 1)", (int)$id);
      $this->database->setQuery($query);
      $this->database->query();
  }
}


