<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @package ExtraWatch  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @version 2.3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @revision 2663  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @copyright (C) 2016 by CodeGravity.com - All rights reserved!  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @website http://www.extrawatch.com  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 */

defined('_JEXEC') or die('Restricted access');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

class ExtraWatchSetup {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    private $database;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    private $env;
    private $modulePath;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    private $sqlScriptsModuleDir;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    private $config;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    function __construct($database) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->env = ExtraWatchEnvFactory::getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database = $database;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->modulePath = realpath(dirname(__FILE__).DS."..".DS."..".DS."..");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->sqlScriptsModuleDir = $this->modulePath. DS . "components" . DS . "com_extrawatch" . DS . "sql" . DS . "scripts";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->config = new ExtraWatchConfig($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function isEwInitialized() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $database = $this->env->getDatabase(_EW_PROJECT_ID); ///

		try {
        $result = @$database->resultQuery("select `value` from #__extrawatch_config where `name` = 'EXTRAWATCH_LIVE_SITE'");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if ($result) { // already initialized  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            return TRUE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
		} catch (Exception $e) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		
		}
        return FALSE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function initializeDB($doNotInitializeIp2c = FALSE)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        if (!$this->isEwInitialized()) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $this->runSQLscriptsFromFile($this->modulePath . DS .  "components" . DS . "com_extrawatch" . DS . "sql" . DS . "install.mysql.utf8.sql");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            if (!$doNotInitializeIp2c) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $this->initializeIp2Country();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            if (@_EW_CLOUD_MODE && (int) @_EW_PROJECT_ID) {

                    require_once (realpath(dirname(__FILE__)).DS."env".DS."nocms".DS."admin".DS."src".DS."class.extrawatch.project.php");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    $extraWatchProject = new ExtraWatchProject($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $username = ExtraWatchInput::validate(_EW_INPUT_EMAIL, @$_SESSION['email']) ?
                        ExtraWatchInput::validate(_EW_INPUT_EMAIL, @$_SESSION['email']) :
                        ExtraWatchInput::validate(_EW_INPUT_EMAIL, @$_REQUEST['email']);  	 ///

                    $extraWatchProject->setTimeOfProjectCreation(_EW_PROJECT_ID);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    @mail(_EW_CLOUD_NOTIFY_EMAIL, "project "._EW_PROJECT_ID." initialized", "project "._EW_PROJECT_ID." initialized");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $this->config->saveConfigValue("EXTRAWATCH_EMAIL_REPORTS_ENABLED", "On");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $this->config->saveConfigValue("EXTRAWATCH_EMAIL_SEO_REPORTS_ENABLED", "On");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $this->config->saveConfigValue("EXTRAWATCH_SPAMWORD_BANS_ENABLED", "On");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $this->config->saveConfigValue("EXTRAWATCH_SPAMWORD_BANS_ENABLED", _EW_EXTRAWATCH_IPINFODB_KEY);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    if ($username) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $this->config->saveConfigValue("EXTRAWATCH_EMAIL_REPORTS_ADDRESS", $username);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }

        }

        $this->runAdditionalSQLScripts();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    public function runAdditionalSQLScripts() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
	try {
        $files = scandir(ExtraWatchInput::validate(_EW_INPUT_DIR, $this->sqlScriptsModuleDir));  	  ///
        foreach ($files as $file) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            if (strstr($file,".sql")) { // should be replaced by ends with  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                if (!$this->wasAdditionalSQLScriptRun($file)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $this->runSQLscriptsFromFile($this->sqlScriptsModuleDir.DS.$file);  	 ///
                    $this->database->executeQuery(sprintf("insert into #__extrawatch_sql_scripts (scriptname) values ('%s')", $this->database->getEscaped($file)));  ///
                }
            }
        }
	} catch (Exception $e) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		ExtraWatchLog::error("An exception while running additional SQL scripts: ".$e->getMessage());  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
	}
    }

    private function wasAdditionalSQLScriptRun($script) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("select count(*) as count from #__extrawatch_sql_scripts where scriptname = '%s'", $this->database->getEscaped($script));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->database->resultQuery(trim($query));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }


    private function runSQLscriptsFromFile($file) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $database = $this->env->getDatabase(_EW_PROJECT_ID);  	  ///
        $lines = file(ExtraWatchInput::validate(_EW_INPUT_FILE_PATH, $file));  	  ///
        $query = "";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        foreach ($lines as $line_num => $line) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query .= " ".trim($line);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            if (strstr(trim($line), ";")) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $query = trim($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $query = str_replace("#__", $this->env->getDbPrefix(), $query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $query = "";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }

        }
    }

    private function initializeIp2Country() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        /*
		$numberOfFiles = 220;
        for ($j = 1; $j <= $numberOfFiles; $j++) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $fileName = $this->modulePath . DIRECTORY_SEPARATOR . "components" . DIRECTORY_SEPARATOR . "com_extrawatch" . DIRECTORY_SEPARATOR . "sql" . DIRECTORY_SEPARATOR . "ip-to-country".DIRECTORY_SEPARATOR."extrawatch-$j.sql";
            $this->runSQLscriptsFromFile($fileName);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        try {
            $dirname = realpath(dirname(__FILE__).DIRECTORY_SEPARATOR."..".DIRECTORY_SEPARATOR."sql".DIRECTORY_SEPARATOR."ip-to-country");
            echo "Removing ip to country directory: $dirname\n";
            ExtraWatchHelper::sureRemoveDir(dirname($dirname), FALSE);
        } catch (Exception $e) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            echo 'Cannot remove directory with SQL files: ', $e->getMessage(), "\n";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
		*/
    }



    static function initializeMenu()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $env = ExtraWatchEnvFactory::getEnvironment();  ///
        $database = $env->getDatabase(_EW_PROJECT_ID); ///

        if (version_compare(JVERSION, "2.5.0", "<")) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $query = "UPDATE #__components SET admin_menu_img='../components/com_extrawatch/img/icons/extrawatch-logo-16x16.png' WHERE admin_menu_link='option=com_extrawatch'";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->setQuery(trim($query));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $query = "DELETE FROM #__components where admin_menu_link like '%option=com_extrawatch%'  and admin_menu_img like '%../components/com_extrawatch/icons/%' and admin_menu_img<>'../components/com_extrawatch/img/icons/extrawatch-logo-16x16.png'";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->setQuery(trim($query));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $query = sprintf("select id from #__components where `name` = '%s' limit 1", "ExtraWatch");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->setQuery(trim($query));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $id = $database->loadResult();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $query = sprintf("INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Live Stats', 0, %d, 'option=com_extrawatch', 0, '../components/com_extrawatch/img/icons/map_icon.gif', 1)", (int)$id);
            $database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('SEO', 0, %d, 'option=com_extrawatch&task=seo', 1, '../components/com_extrawatch/img/icons/seo.png', 1)", (int)$id);
            $database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Clicks', 0, %d, 'option=com_extrawatch&task=heatmap', 2, '../components/com_extrawatch/img/icons/click.png', 1)", (int)$id);
            $database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Downloads', 0, %d, 'option=com_extrawatch&task=downloads', 3, '../components/com_extrawatch/img/icons/downloads.png', 1)", (int)$id);
            $database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Traffic Flow', 0, %d, 'option=com_extrawatch&task=flow', 4, '../components/com_extrawatch/img/icons/flow.png', 1)", (int)$id);
            $database->setQuery($query);
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Graphs & Trends', 0, %d, 'option=com_extrawatch&task=graphs', 5, '../components/com_extrawatch/img/icons/trend_icon.gif', 1)", (int)$id);
            $database->setQuery($query);
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Goals', 0, %d, 'option=com_extrawatch&task=goals', 6, '../components/com_extrawatch/img/icons/goal.gif', 1)", (int)$id);
            $database->setQuery($query);
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Visit History', 0, %d, 'option=com_extrawatch&task=history', 7, '../components/com_extrawatch/img/icons/history.png', 1)", (int)$id);
            $database->setQuery($query);
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Anti-spam & Blocking', 0, %d, 'option=com_extrawatch&task=antiSpam', 8, '../components/com_extrawatch/img/icons/antispam.gif', 1)", (int)$id);
            $database->setQuery($query);
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Email Reports', 0, %d, 'option=com_extrawatch&task=emails', 9, '../components/com_extrawatch/img/icons/emails.png', 1)", (int)$id);
            $database->setQuery($query);
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Your License', 0, %d, 'option=com_extrawatch&task=license', 10, '../components/com_extrawatch/img/icons/license.png', 1)", (int)$id);
            $database->setQuery($query);
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Database Status', 0, %d, 'option=com_extrawatch&task=status', 11, '../components/com_extrawatch/img/icons/status.png', 1)", (int)$id);
            $database->setQuery($query);
            $database->query();
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Modules / Components Sizes', 0, %d, 'option=com_extrawatch&task=sizes', 12, '../components/com_extrawatch/img/icons/sizes.png', 1)", (int)$id);
            $database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) values ('Settings', 0, %d, 'option=com_extrawatch&task=settings', 13, '../components/com_extrawatch/img/icons/settings.gif', 1)", (int)$id);
            $database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) ('Update', 0, %d, 'option=com_extrawatch&task=update', 14, '../components/com_extrawatch/img/icons/update.png', 1)", (int)$id);
            $database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("   INSERT INTO #__components (`name`, menuid, parent, link, ordering, admin_menu_img, enabled) ('Credits', 0, %d, 'option=com_extrawatch&task=credits', 15, '../components/com_extrawatch/img/icons/credits.png', 1)", (int)$id);
            $database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        }
    }

    function resetData()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        foreach (unserialize(EXTRAWATCH_TABLES_TO_TRUNCATE) as $table) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("DELETE FROM `%s`", $this->database->getEscaped($table));
            $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        return TRUE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function dropTables()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $query = sprintf("DROP TABLE #__extrawatch_uri");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        foreach ($this->getExtraWatchTables() as $table => $value) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("DROP TABLE `%s`", $this->database->getEscaped($value->Name));
            $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        return TRUE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }



    function getExtraWatchTables()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $dbPrefix = $this->env->getDbPrefix();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("SHOW TABLE STATUS LIKE '%sextrawatch%%'", $this->database->getEscaped($dbPrefix));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->setQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rows = $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $rows;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

}


