<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @package ExtraWatch  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @version 2.3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @revision 2663  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @copyright (C) 2016 by CodeGravity.com - All rights reserved!  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @website http://www.extrawatch.com  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 */

defined('_JEXEC') or die('Restricted access');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

class ExtraWatchGoal  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
{

    public $database;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    public $helper;
    public $stat;
    public $block;
    public $config;

    function __construct($database)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $this->database = $database;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->helper = new ExtraWatchHelper($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->stat = new ExtraWatchStat($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->block = new ExtraWatchBlock($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->config = new ExtraWatchConfig($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    /**
     * goals
     */
    function getGoals()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $query = "select * from #__extrawatch_goals ";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rows = @ $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return @ $rows;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    /**
     * goals
     */
    function getGoalNameById($id)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $query = sprintf("select name from #__extrawatch_goals where id = '%d'", (int) $id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rows = @ $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $row = @ $rows[0];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return @ $row->name;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }


    /**
     * goals
     */
    function getGoalById($id)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {

        //lower case id  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $id = strtolower($id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("select * from #__extrawatch_goals where id = '%d' limit 1 ", (int) $id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rows = $this->database->assocListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $row = @ $rows[0];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $row;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    }

    /**
     * goals
     */
    function deleteGoal($id)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $query = sprintf("delete from #__extrawatch_goals where id = '%d' limit 1", (int) $id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        //TODO delete everyting from logs as well!  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $result = $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $query = sprintf("delete from #__extrawatch_info where (`group`='%d' and name='%d')", (int)EW_DB_KEY_GOALS, (int) $id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $result;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    /**
     * goals
     */
    function enableGoal($id)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $query = sprintf("update #__extrawatch_goals set disabled = NULL where id = '%d'", (int) $id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    /**
     * goals
     */
    function disableGoal($id)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $query = sprintf("update #__extrawatch_goals set disabled = 1 where id = '%d'", (int) $id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    /**
     * goals
     */
    function getGoalCount($id)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
		/*        
		$query = sprintf("select sum(value) as sum from #__extrawatch_info where `group` = '" . EW_DB_KEY_GOALS . "' and name = '%d'", (int) $id);
        $sum = $this->database->resultQuery($query);
		*/

        $query = sprintf("select count(goalId) as `count` from #__extrawatch_visit2goal where `goalId` = '%d'", (int) $id);
        $count = $this->database->resultQuery($query);

        return $count;
    }

    /**
     * goals
     */
    function saveGoal($post)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $allowedFields = unserialize(EXTRAWATCH_GOALS_ALLOWED_FIELDS);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $keys = array();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $values = array();
        $env = ExtraWatchEnvFactory::getEnvironment();
        foreach ($allowedFields as $key) {
            $key = ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, $key);
            $value = @$post[$key];   ///
            if (array_search($key, $allowedFields)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $keys[] = strtolower($key);
                if (@get_class($env) != "ExtraWatchWordpressEnv") { //wordpress post values come pre-escaped
                    $value = sprintf("%s", $this->database->getEscaped($value));
                } else {
                    if ($key == "CLICKED_ELEMENT_XPATH_CONDITION") {
                        $value = $this->unescapeXPathCondition($value);
                    }
                }
                $values[] = "'".$this->database->getEscaped($value)."'";
            }
        }
        $keysImploded = implode(",", $keys);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $valuesImploded = implode(",", $values);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $id = (int) @ $post['id'];
        if (@ $id) {    // update  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            for($i=0;$i<sizeof($keys);$i++) {
                 $updateKeys[] =  ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, $keys[$i])." = ". $values[$i]."";
            }
            $updateQuery = implode(", ", $updateKeys);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("update #__extrawatch_goals set %s  where id = '%d'", $updateQuery, (int) $id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $result = $this->database->executeQuery($query);
        } else {
            // insert  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = "insert into #__extrawatch_goals (".$keysImploded.") values (".$valuesImploded.")";
            $result = $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        return $result;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    /**
     * goals
     */
    function checkGoals($title, $username, $ip, $came_from, $liveSite = "", $clickedXpath = "")
    {

        $query = sprintf("select * from #__extrawatch_goals");
        $rows = $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (@$rows)
            foreach ($rows as $row) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                $achieved = array();
                if ($row->disabled) {
                    continue;
                }
                      	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                if (@trim(@$row->clicked_element_xpath_condition) ) {
                    @$achieved[clicked_element_xpath_condition] = FALSE;
                    if (@$this->helper->wildcardSearch(trim(@$row->clicked_element_xpath_condition),$clickedXpath)) {
                        @$achieved[clicked_element_xpath_condition] = TRUE;
                    }
                } else {

                    if (@trim($row->uri_inversed) == "on") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->uri_condition)) {
                            @$achieved[uri_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->uri_condition, trim($this->helper->getURI()))) {
                            } else {
                                @$achieved[uri_condition] = TRUE;
                            }
                        }
                    } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->uri_condition)) {
                            @$achieved[uri_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->uri_condition, trim($this->helper->getURI()))) {
                                @$achieved[uri_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    if (@trim($row->get_inversed) == "on") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->get_condition)) {
                            @$achieved[get_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->get_condition, trim( ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, ExtraWatchHelper::requestGet($row->get_var))))) { ///
                                  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            } else  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                if ($row->get_var == "*") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    $found = FALSE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    foreach (ExtraWatchHelper::requestGet() as $get) {  ///
                                        if ($this->helper->wildcardSearch($row->get_condition, trim($get))) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                            $found = TRUE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    }  	 	
                                    if ($found) {
										@$achieved[uri_condition] = FALSE;
									}  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                } else {
                                    @$achieved[uri_condition] = TRUE;
                                }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->get_condition)) {
                            @$achieved[get_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->get_condition, trim( ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, ExtraWatchHelper::requestGet($row->get_var))))) { ///
                                @$achieved[get_condition] = TRUE;
                            } else  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                if ($row->get_var == "*") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    foreach (ExtraWatchHelper::requestGet() as $get) {   ///
                                        if ($this->helper->wildcardSearch($row->get_condition, trim($get))) {
                                            @$achieved[get_condition] = TRUE;
                                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    if (@trim($row->post_inversed) == "on") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->post_condition)) {
                            @$achieved[post_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->post_condition, trim( ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, ExtraWatchHelper::requestPost($row->post_var))))) { ///
                                  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            } else  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                if ($row->post_var == "*") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    $found = FALSE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    foreach (ExtraWatchHelper::requestPost() as $post) {   ///
                                        if ($this->helper->wildcardSearch($row->post_condition, trim($post))) {   ///
                                            $found = TRUE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    if ($found) {
                                        @$achieved[post_condition] = FALSE;
                                    }
                                } else {
                                    @$achieved[post_condition] = TRUE;
                                }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->post_condition)) {
                            @$achieved[post_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->post_condition, trim( ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, ExtraWatchHelper::requestPost($row->post_var))))) { ///
                                @$achieved[post_condition] = TRUE;
                            } else  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                if ($row->post_var == "*") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    foreach (ExtraWatchHelper::requestPost() as $post) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                        if ($this->helper->wildcardSearch($row->post_condition, trim($post))) {
                                            @$achieved[post_condition] = TRUE;
                                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                                }
                                      	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    if (@trim($row->title_inversed) == "on") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->title_condition)) {
                            @$achieved[title_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->title_condition, trim($title))) {
                                  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            } else
                                @$achieved[title_condition] = TRUE;
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->title_condition)) {
                            @$achieved[title_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->title_condition, trim($title))) {
                                @$achieved[title_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    if (@trim($row->username_inversed) == "on") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->username_condition)) {
                            @$achieved[username_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->username_condition, trim($username))) {
                                  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            } else {
                                @$achieved[username_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->username_condition)) {
                            @$achieved[username_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->username_condition, trim($username))) {
                                @$achieved[username_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    if (@trim($row->ip_inversed) == "on") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->ip_condition)) {
                            @$achieved[ip_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->ip_condition, trim($ip))) {
                                  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            } else {
                                @$achieved[ip_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->ip_condition)) {
                            @$achieved[ip_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->ip_condition, trim($ip))) {
                                @$achieved[ip_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    if (@trim($row->came_from_inversed) == "on") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->came_from_condition)) {
                            @$achieved[came_from_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->came_from_condition, trim($came_from)) || $this->helper->wildcardSearch($liveSite . $row->came_from_condition, trim($came_from))) {
                                  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            } else {
                                @$achieved[came_from_condition] = TRUE;
                            }
                        }
                    } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->came_from_condition)) {
                            @$achieved[came_from_condition] = FALSE;
                            if (@ $this->helper->wildcardSearch($row->came_from_condition, trim($came_from)) || $this->helper->wildcardSearch($liveSite . $row->came_from_condition, trim($came_from))) {
                                @$achieved[came_from_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    if (@trim($row->country_inversed) == "on") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (@trim($row->country_condition)) {
                            @$achieved[came_from_condition] = FALSE;
                            $country = $this->helper->countryByIp($ip); //performance optim. - checking country only if there is some condition
                            if (@ $this->helper->wildcardSearch($row->country_condition, trim($country))) {
                            } else {
                                @$achieved[came_from_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    } else {
                        if (@trim($row->country_condition)) {
                            @$achieved[country_condition] = FALSE;
                            $country = $this->helper->countryByIp($ip); //performance optim. - checking country only if there is some condition
                            if (@ $this->helper->wildcardSearch($row->country_condition, trim($country))) {
                                @$achieved[country_condition] = TRUE;
                            }
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }



                if ($this->evaluateAchievedGoals($achieved)) {
                      	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
					$this->stat->increaseKeyValueInGroup(EW_DB_KEY_GOALS, $row->id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $this->addIp2GoalId($ip, $row->id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  


                    if ($this->config->getCheckboxBooleanValue($row->send_email)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $totalAchievedCountToday = $this->stat->getIntValueByNameAndValue(EW_DB_KEY_GOALS, $row->id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

					    $email = $this->config->getConfigValue("EXTRAWATCH_EMAIL_REPORTS_ADDRESS");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $env = ExtraWatchInput::validate(_EW_INPUT_ENV, ExtraWatchEnvFactory::getEnvironment());
					    $ip = ExtraWatchInput::validate(_EW_INPUT_IP, ExtraWatchVisit::getRemoteIPAddress());  	 ///
                        $subject = sprintf(_EW_GOAL_EMAIL_SUBJECT, $row->name, $totalAchievedCountToday);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        require_once(realpath(dirname(__FILE__)).DS."html".DS."class.extrawatch.visit.html.php");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $extraWatch = new ExtraWatchMain();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $extraWatchVisitHTML = new ExtraWatchVisitHTML($extraWatch);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $visitsOutput = $extraWatchVisitHTML->renderTable(FALSE, 0, $ip, TRUE);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
						$visitsOutput .= $extraWatchVisitHTML->renderTable(FALSE, 1, $ip, TRUE);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $body = "ip: <b>$ip</b><br/>$visitsOutput";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  


                        ExtraWatchHelper::sendEmail($env, $email, $email, $subject, $body);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }


                    if (@ $row->redirect) {
                        $env = ExtraWatchInput::validate(_EW_INPUT_ENV, ExtraWatchEnvFactory::getEnvironment()); ///
                        $env->redirect(@$row->redirect);
                    }
                    if (@ $row->block) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $blockReason = sprintf(_EW_BLOCKED_BASED_ON_GOAL, $row->id);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $this->block->blockIp($ip, $blockReason);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        try {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            $this->block->dieWithBlockingMessage($ip);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        } catch (ExtraWatchIPBlockedException $exception) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            die($exception->getBlockingMessage());  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }

            }
    }

	/**
	* This function goes through all conditions if they were set, and if they all were evaluated to TRUE.
    * this is kind of an AND operator between all conditoins if they were set
	*/
    function evaluateAchievedGoals($achieved)
    {
        $achievedCount = 0;
        foreach ($achieved as $key => $value) {
            if ($value == TRUE) {
                $achievedCount++;
            }
        }
        if ($achievedCount == sizeof($achieved)) {
            return TRUE;
        }
        return FALSE;
    }

    /**
     *  Export Goals  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
     */
    function exportGoals()
    {
        $query = "select * from #__extrawatch_goals ";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rows = @ $this->database->assocListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $output = "<?xml version=\"1.0\" ?>\n";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $output .= "<goals>"; // iterate over each table and return the fields for each table  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        foreach ($rows as $key => $row) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $output .= "<goal>";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            foreach ($row as $resultKey => $resultRow) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                if ($resultKey != 'id') {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $output .= "<" . $resultKey . ">" . $resultRow . "</" . $resultKey . ">";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }
            }
            $output .= "</goal>";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }

        $output .= "</goals>";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $xmlFile = ExtraWatchInput::getUploadTmpDir().DS."extrawatch-goals-" . date('Ymd') . ".xml";
        $xmlHandle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_PATH_TMP, $xmlFile), "w"); //--- write xml to file ---   ///
        fwrite($xmlHandle, $output);  	  ///
        fclose($xmlHandle); // tell the browser what kind of file is come in  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return @ $output;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function saveImportGoal($post)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        ExtraWatchInput::validate(_EW_INPUT_FILE_NAME, $_FILES); ///**

        if ((($_FILES["file"]["type"] == "text/xml"))) {
            if ($_FILES["file"]["error"] > 0) {
                echo "Return Code: " . $_FILES["file"]["error"] . "<br />";
            } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                if (file_exists(JPATH_BASE . "/" . $_FILES["file"]["name"])) {  	 ///
                    echo $_FILES["file"]["name"] . " already exists. ";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                } else {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    move_uploaded_file($_FILES["file"]["tmp_name"], JPATH_BASE . "/" . $_FILES["file"]["name"]);  ///
                    //XML Read  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $doc = new DOMDocument();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    $doc->load($_FILES['file']['name']);  	 ///

                    $goals = $doc->getElementsByTagName("goal");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    foreach ($goals as $goal) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $names = $goal->getElementsByTagName("name");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $name = $names->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $username_inverseds = $goal->getElementsByTagName("username_inversed");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $username_inversed = $username_inverseds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $parentIds = $goal->getElementsByTagName("parentId");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $parentId = $parentIds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $uri_conditions = $goal->getElementsByTagName("uri_condition");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $uri_condition = $uri_conditions->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $uri_inverseds = $goal->getElementsByTagName("uri_inversed");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $uri_inversed = $uri_inverseds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $get_vars = $goal->getElementsByTagName("get_var");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $get_var = $get_vars->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $get_conditions = $goal->getElementsByTagName("get_condition");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $get_condition = $get_conditions->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $get_inverseds = $goal->getElementsByTagName("get_inversed");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $get_inversed = $get_inverseds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $post_vars = $goal->getElementsByTagName("post_var");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $post_var = $post_vars->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $post_conditions = $goal->getElementsByTagName("post_condition");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $post_condition = $post_conditions->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $post_inverseds = $goal->getElementsByTagName("post_inversed");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $post_inversed = $post_inverseds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $title_conditions = $goal->getElementsByTagName("title_condition");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $title_condition = $title_conditions->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $title_inverseds = $goal->getElementsByTagName("title_inversed");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $title_inversed = $title_inverseds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $username_conditions = $goal->getElementsByTagName("username_condition");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $username_condition = $username_conditions->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $ip_conditions = $goal->getElementsByTagName("ip_condition");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $ip_condition = $ip_conditions->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $ip_inverseds = $goal->getElementsByTagName("ip_inversed");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $ip_inversed = $ip_inverseds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $came_from_conditions = $goal->getElementsByTagName("came_from_condition");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $came_from_condition = $came_from_conditions->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $came_from_inverseds = $goal->getElementsByTagName("came_from_inversed");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $came_from_inversed = $came_from_inverseds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $country_conditions = $goal->getElementsByTagName("country_condition");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $country_condition = $country_conditions->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $country_inverseds = $goal->getElementsByTagName("country_inversed");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $country_inversed = $country_inverseds->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $blocks = $goal->getElementsByTagName("block");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $block = $blocks->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $redirects = $goal->getElementsByTagName("redirect");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $redirect = $redirects->item(0)->nodeValue;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        $disableds = $goal->getElementsByTagName("disabled");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $disabled = $disableds->item(0)->nodeValue;

                        $clicked_element_xpath_conditions = $goal->getElementsByTagName("clicked_element_xpath_condition");
                        $clicked_element_xpath_condition = $clicked_element_xpath_conditions->item(0)->nodeValue;

                        $send_emails = $goal->getElementsByTagName("send_email");
                        $send_email = $send_emails->item(0)->nodeValue;

                        //Check the Goal is exist or not  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $query = sprintf("select name from #__extrawatch_goals where `name` = '$name'");
                        $rows = @ $this->database->assocListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        if (empty($rows)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            $value = "'$name','$username_inversed','$parentId','$uri_condition','$uri_inversed','$get_var','$get_condition','$get_inversed',                                     '$post_var','$post_condition','$post_inversed','$title_condition','$title_inversed','$username_condition','$ip_condition','$ip_inversed',                                     '$came_from_condition','$came_from_inversed','$country_condition','$country_inversed','$block','$redirect','$disabled', '$clicked_element_xpath_condition', '$send_email'";
                            //$query = sprintf("insert into #__extrawatch_goals values('NULL','$name','$username_inversed','$parentId','$uri_condition','$uri_inversed','$get_var','$get_condition','$get_inversed','$post_var','$post_condition','$post_inversed','$title_condition','$title_inversed','$username_condition','$ip_condition','$ip_inversed','$came_from_condition','$came_from_inversed','$country_condition','$country_inversed','$block','$redirect','$disabled')");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                            $query = sprintf("insert into #__extrawatch_goals (`name`, `username_inversed`, `parentId` , `uri_condition`, `uri_inversed` , `get_var` , `get_condition`, `get_inversed` , `post_var` , `post_condition`, `post_inversed` , `title_condition`, `title_inversed`, `username_condition`, `ip_condition` , `ip_inversed` , `came_from_condition`, `came_from_inversed`, `country_condition` , `country_inversed` , `block` , `redirect` , `disabled`, `clicked_element_xpath_condition`, `send_email`)
                                                values (".$value.")");
                            $result = $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    } //Delete uploaded file  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    unlink($_FILES["file"]["name"]);  	 ///
                }
            }
        } else {
            echo "Invalid file";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        return $result;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function addIp2GoalId($ip, $goalId) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("select id from #__extrawatch where `ip` = '%s'", $this->database->getEscaped($ip));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $visitId = $this->database->resultQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $query = sprintf("insert into #__extrawatch_visit2goal (visitId,goalId,timestamp) values ('%d', '%d', '%d')", (int) $visitId, (int) $goalId, (int) ExtraWatchDate::getUTCTimestamp());  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function getGoalsForVisitIdBetweenTimestamps($visitId, $earlierTimestamp, $laterTimestamp) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("SELECT `name`, goalId, `timestamp` FROM  `#__extrawatch_visit2goal` LEFT JOIN `#__extrawatch_goals` ON `#__extrawatch_goals`.id = `#__extrawatch_visit2goal`.goalId  where `#__extrawatch_visit2goal`.visitId = '%d' and (%d > `timestamp`) and (`timestamp` > %d) ORDER BY `#__extrawatch_visit2goal`.timestamp DESC ", (int) $visitId, (int) $earlierTimestamp, (int) $laterTimestamp);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    /**
	 * Unescapes \\" to "
     * @param $value
     * @return mixed
     */
    public function unescapeXPathCondition($value)
    {
        $value = str_replace("\\\"", "\"", $value);
        $value = str_replace("\\\"", "\"", $value);
        return $value;
    }


}


