<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @package ExtraWatch  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @version 2.3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @revision 2663  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @copyright (C) 2016 by CodeGravity.com - All rights reserved!  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @website http://www.codegravity.com  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 */

defined('_JEXEC') or die('Restricted access');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

class ExtraWatchDownloads  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
{

    public $database;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    public $config;
    public $helper;
    public $env;
    public $date;

    const EW_DOWNLOAD_URL_PART = "task=ajax&action=download&env";

    const DOWNLOADS_QUERY = "
                select 
                #__extrawatch_dm_paths.did as did, 
                #__extrawatch_dm_paths.dname as dname,
                count(#__extrawatch_dm_paths.did) as `count` 
                from #__extrawatch_dm_paths 
                left join #__extrawatch_dm_counter 
                on #__extrawatch_dm_paths.did = #__extrawatch_dm_counter.did
                %s
                group by #__extrawatch_dm_paths.did
                order by count desc limit %d
                ";

    function __construct($database)
    {
        $this->database = $database;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->env = ExtraWatchEnvFactory::getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->config = new ExtraWatchConfig($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->helper = new ExtraWatchHelper($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->date = new ExtraWatchDate($this->database);

        $this->chartsDownloadsLimit = $this->config->getConfigValue('EXTRAWATCH_CHARTS_DOWNLOAD_LIMIT');
    }

    function checkIfReferrerAllowed($file, $referrer) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("SELECT allowedReferrer FROM #__extrawatch_dm_paths where dname='%s'", $this->database->getEscaped($file));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $allowedReferrer = $this->database->resultQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (@$allowedReferrer) {    // if there's some, we're going to check it  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            if (!$referrer || !strpos($allowedReferrer,$referrer) === 0) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                return FALSE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }
        return TRUE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function increaseFileDownload($file) {

        if(!$file) {
            echo _EW_DOWNLOADS_FILE_NOT_FOUND;
            return;
        }

        $fileExtension = pathinfo($file, PATHINFO_EXTENSION);

        if (!$this->checkIfExtensionAllowed($fileExtension)) {
            die("Downloading file with this extension is not allowed!");
        }

        set_time_limit(0);
        $filepath = $this->env->getRootPath().DS.trim($file);
        $mimeType = $this->mime_content_type($filepath);


        $referrer = ExtraWatchInput::validate(_EW_INPUT_REFERRER, ExtraWatchVisit::getReferer());///
        $ip = ExtraWatchInput::validate(_EW_INPUT_IP, ExtraWatchVisit::getRemoteIPAddress());///

        if (!$this->checkIfReferrerAllowed($file, $referrer)) {
            $adminEmail = $this->helper->getAdminEmail($this->env);
            $adminEmailReplaced = str_replace("@"," {at} ", $adminEmail);
            $emailSubject = sprintf(_EW_DOWNLOADS_EMAIL_RESTRICTED_SUBJECT, $ip);
            $emailContent = sprintf(_EW_DOWNLOADS_EMAIL_RESTRICTED_BODY, $ip, $file, $referrer);
            $this->helper->sendEmail($this->env, $adminEmail, $adminEmail, $emailSubject, $emailContent);
            die(sprintf(_EW_DOWNLOADS_NOT_ALLOWED, $adminEmailReplaced));
        }

        if (!@$this->config->isIgnored('IP', $ip)) { // do not count downloads for excluded IP addresses
            $this->increaseDownloadStat($file);
        }

        $this->serveDownload($filepath, 1024, $mimeType);

    }


    /**
     * This is
     */
    function checkIfHtAccessTxtPresentOnJoomla() {

        if ($this->env->getEnvironmentName() == "joomla") {
            $rootPath = $this->env->getRootPath();
            $htaccess_file = $rootPath.DS."htaccess.txt";
            if (@file_exists($htaccess_file)) {
                return TRUE;
            }
            return FALSE;
        }
    }
	
    function addExtension($extName) {

        if ($this->checkIfHtAccessTxtPresentOnJoomla()) {
            return FALSE;
        }

        $extensionquery_ht_prev = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $extensionar_ht_prev = $this->database->objectListQuery($extensionquery_ht_prev);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $ext_n_prev = "";  	 	    
		if (@$extensionar_ht_prev)
        foreach($extensionar_ht_prev as $extensionhtprev)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            if (trim($extensionhtprev->extname)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $ext_n_prev = $ext_n_prev.$extensionhtprev->extname."|";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }
        $ext_n_prev = substr($ext_n_prev,0,strlen($ext_n_prev)-1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  



        $extensionquery_add = sprintf("insert into #__extrawatch_dm_extension (extname) values ('%s')", $this->database->getEscaped($extName));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->executeQuery($extensionquery_add);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $extensionquery_ht = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $extensionar_ht = $this->database->objectListQuery($extensionquery_ht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $ext_n = "";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		if (@$extensionar_ht)
        foreach($extensionar_ht as $extensionht)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            if (trim($extensionht->extname)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $ext_n = $ext_n.$extensionht->extname."|";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }
        $ext_n = substr($ext_n,0,strlen($ext_n)-1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $path = $this->env->getRootSite().$this->env->getEnvironmentSuffix();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

		$env = $this->config->getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $writingonht_prev = "\nRewriteEngine on"."\n"."RewriteRule ^(.*).(".$ext_n_prev.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1.$2 [R,L]";

        $root_file = $this->env->getRootPath().DS.".htaccess";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $existingcode = @file_get_contents(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS, $root_file));  ///

        $existingcode_f = str_replace($writingonht_prev,"",$existingcode);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $writingonht = $existingcode_f."\nRewriteEngine on";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $writingonht = $writingonht."\n"."RewriteRule ^(.*).(".$ext_n.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1.$2 [R,L]";

        if (file_exists($root_file))  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            if (is_writable($root_file))  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w"); ///
                fwrite($handle,$writingonht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            else
            {
                echo _EW_DOWNLOADS_HTACCESS_NOT_WRITABLE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }
        else
        {
            $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w");  ///
            if ($handle)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                fwrite($handle,$writingonht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            else
            {
                echo _EW_DOWNLOADS_HTACCESS_COULD_NOT_BE_CREATED;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }

    }

    function addFilePath($filepathnamename, $allowedReferrer = "") {

        if ($this->checkIfHtAccessTxtPresentOnJoomla()) {
            return FALSE;
        }

        $pathsBeforeInsert = $this->database->objectListQuery(sprintf("SELECT * FROM #__extrawatch_dm_paths where addedManually = 1"));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        if ($this->config->getLiveSite() != "/") {
            $filepathnamename = str_replace($this->config->getLiveSite(), "", $filepathnamename);
        }

        /** inserting new path */  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->executeQuery(sprintf("insert into #__extrawatch_dm_paths (dname, addedManually, allowedReferrer) values ('%s', 1, '%s')", $this->database->getEscaped($filepathnamename), $this->database->getEscaped($allowedReferrer)));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $pathsAfterInsert = $this->database->objectListQuery(sprintf("SELECT dname FROM #__extrawatch_dm_paths where addedManually = 1"));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  



        $path = $this->env->getRootSite().$this->env->getEnvironmentSuffix();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $env = $this->config->getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $pathsDividedBySeparator = $this->objectListToString($pathsBeforeInsert,"|");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  


        $textBeforeInHtAccess = "\nRewriteEngine on"."\n"."RewriteRule ^(".$pathsDividedBySeparator.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1 [R,L]";

        $root_file = $this->env->getRootPath().DS.".htaccess";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $existingContentOfHtAccess = @file_get_contents(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file));  ///

        $originalContentOfHtAccess = str_replace($textBeforeInHtAccess,"",$existingContentOfHtAccess);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $pathsDividedBySeparator = $this->objectListToString($pathsAfterInsert,"|");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $newContentToWriteToHtAccess = $originalContentOfHtAccess."\nRewriteEngine on\n";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $newContentToWriteToHtAccess .= "RewriteRule ^(".$pathsDividedBySeparator.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1 [R,L]";

        $this->writeToFile($root_file, $newContentToWriteToHtAccess);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  


    }

    function updateExtension($eid, $extname) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $extensionquery_ht_prev = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $extensionar_ht_prev = $this->database->objectListQuery($extensionquery_ht_prev);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $ext_n_prev = "";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (@$extensionar_ht_prev)
		foreach($extensionar_ht_prev as $extensionhtprev)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            if (trim($extensionhtprev->extname)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $ext_n_prev = $ext_n_prev.$extensionhtprev->extname."|";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }
        $ext_n_prev = substr($ext_n_prev,0,strlen($ext_n_prev)-1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $extensionquery = sprintf("update #__extrawatch_dm_extension set extname='%s' where eid='%d'", $this->database->getEscaped($extname), (int) $eid);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->setQuery($extensionquery);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $extensionquery_ht = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $extensionar_ht = $this->database->objectListQuery($extensionquery_ht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $ext_n = "";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (@$extensionar_ht)
        foreach($extensionar_ht as $extensionht)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            if (trim($extensionht->extname)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $ext_n = $ext_n.$extensionht->extname."|";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }
        $ext_n = substr($ext_n,0,strlen($ext_n)-1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $path = $this->env->getRootSite().$this->env->getEnvironmentSuffix();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

		$env = $this->config->getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $writingonht_prev = "\nRewriteEngine on"."\n"."RewriteRule ^(.*).(".$ext_n_prev.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1.$2 [R,L]";

        $root_file = $this->env->getRootPath().DS.".htaccess";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $existingcode = file_get_contents(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file));  ///

        $existingcode_f = str_replace($writingonht_prev,"",$existingcode);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        //$existingcode_f = str_replace($writingonht_prev1,"",$existingcode);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $writingonht = $existingcode_f."\nRewriteEngine on";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $writingonht = $writingonht."\n"."RewriteRule ^(.*).(".$ext_n.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1.$2 [R,L]";


        if (file_exists($root_file))  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            if (is_writable($root_file))  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w");///
                fwrite($handle,$writingonht);  ///
                fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            else
            {
                echo _EW_DOWNLOADS_HTACCESS_NOT_WRITABLE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }
        else
        {
            $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w");   ///
            if ($handle)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                fwrite($handle,$writingonht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            else
            {
                echo _EW_DOWNLOADS_HTACCESS_COULD_NOT_BE_CREATED;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }


    }

    function findExtensionNameById($eid) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $extensionquery_edit = sprintf("SELECT extname FROM #__extrawatch_dm_extension where eid='%d'",(int)$eid);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $editextname = $this->database->resultQuery($extensionquery_edit);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $editextname;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function  findFilePathNameById($did) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $filepathquery_edit = sprintf("SELECT dname FROM #__extrawatch_dm_paths where did='%d'", (int)$did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $editfilepathname = $this->database->resultQuery($filepathquery_edit);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $editfilepathname;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function updateFilePath($did, $filepathname, $allowedReferrer = "") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $filepathquery = sprintf("update #__extrawatch_dm_paths set dname='%s', allowedReferrer='%s' where did='%d'", $this->database->getEscaped($filepathname), $this->database->getEscaped($allowedReferrer), (int) $did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->setQuery($filepathquery);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    }

    function deleteExtension($co) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {

            $extensionquery_ht_prev = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $extensionar_ht_prev = $this->database->objectListQuery($extensionquery_ht_prev);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $ext_n_prev = "";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
			if (@$extensionar_ht_prev)
            foreach($extensionar_ht_prev as $extensionhtprev)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                $ext_n_prev = $ext_n_prev.$extensionhtprev->extname."|";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            $ext_n_prev = substr($ext_n_prev,0,strlen($ext_n_prev)-1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $extensionquery_del = sprintf("delete from #__extrawatch_dm_extension where eid='%d'", (int) $co);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $this->database->executeQuery($extensionquery_del);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $extensionquery_ht = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $extensionar_ht = $this->database->objectListQuery($extensionquery_ht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $ext_n = "";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
			if (@$extensionar_ht)
            foreach($extensionar_ht as $extensionht)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                $ext_n = $ext_n.$extensionht->extname."|";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            $ext_n = substr($ext_n,0,strlen($ext_n)-1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  


            $path = $this->env->getRootSite().$this->env->getEnvironmentSuffix();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

			$env = $this->config->getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $writingonht_prev = "\nRewriteEngine on"."\n"."RewriteRule ^(.*).(".$ext_n_prev.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1.$2 [R,L]";

            $root_file = $this->env->getRootPath().DS.".htaccess";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $existingcode = @file_get_contents(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file)); ///

            if (!@$existingcode) {

            $existingcode_f = str_replace($writingonht_prev,"",$existingcode);
            //$existingcode_f = str_replace($writingonht_prev1,"",$existingcode);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $writingonht = $existingcode_f."\nRewriteEngine on";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $writingonht = $writingonht."\n"."RewriteRule ^(.*).(".$ext_n.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1.$2 [R,L]";

            if (file_exists($root_file))  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                if (is_writable($root_file))  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    if($ext_n!="")  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w");  	 ///
                        fwrite($handle,$writingonht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }
                }
                else  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w");  	  ///
                    fwrite($handle,$existingcode_f);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }
            }
            else
            {
                $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w");  	 	 ///
                if ($handle)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    fwrite($handle,$writingonht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }
                else  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    echo _EW_DOWNLOADS_HTACCESS_COULD_NOT_BE_CREATED;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }
            }

        } else {

                echo("ERROR: could not get content of $root_file ");

        }

        }

    }

    function deleteEverythingFromHtaccess() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $extensionquery_ht_prev = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $extensionar_ht_prev = $this->database->objectListQuery($extensionquery_ht_prev);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $ext_n_prev = "";

            if (@$extensionar_ht_prev)
            foreach($extensionar_ht_prev as $extensionhtprev)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                $ext_n_prev = $ext_n_prev.$extensionhtprev->extname."|";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            $ext_n_prev = substr($ext_n_prev,0,strlen($ext_n_prev)-1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $extensionquery_ht = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $extensionar_ht = $this->database->objectListQuery($extensionquery_ht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $ext_n = "";

            if (@$extensionar_ht)
            foreach($extensionar_ht as $extensionht)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                $ext_n = $ext_n.$extensionht->extname."|";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
            $ext_n = substr($ext_n,0,strlen($ext_n)-1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  


            $path = $this->env->getRootSite().$this->env->getEnvironmentSuffix();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $env = $this->config->getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            $writingonht_prev = "\nRewriteEngine on"."\n"."RewriteRule ^(.*).(".$ext_n_prev.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1.$2 [R,L]";

            $root_file = $this->env->getRootPath().DS.".htaccess";

            if (@file_exists($root_file)) {
                $existingcode = file_get_contents(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file)); ///

                $existingcode_f = str_replace($writingonht_prev,"",$existingcode);

                $writingonht = $existingcode_f."\nRewriteEngine on";
                $writingonht = $writingonht."\n"."RewriteRule ^(.*).(".$ext_n.")$ ".$path.$this->env->renderFrontendAjaxLink($this->config, 'ajax','download', TRUE)."&env=$env&params=".urlencode("&rand=")."&file="."$1.$2 [R,L]";

                if (file_exists($root_file)) {
                    if (is_writable($root_file))
                    {
                        if($ext_n!="")
                        {
                            $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w"); ///
                            fwrite($handle,$writingonht);
                            fclose($handle);
                        }
                    }
                    else
                    {
                        $handle = @fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file),"w"); ///
                        if (@$handle) {
                            fwrite($handle,$existingcode_f);
                            fclose($handle);
                        }
                    }
                }
            }
        }



    function deleteFilePath($co) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $extensionquery_del = sprintf("delete from #__extrawatch_dm_paths where did='%d'", (int)$co);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->setQuery($extensionquery_del);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->database->query();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function getFileStatistics($did) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $month = date("m");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $week = date("N");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $curryear = date("Y");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $currmonth = date("Y-m");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $currdate = date("Y-m-d");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $yesterday = date("Y-m-d", (strtotime($currdate)-(60*60*24)));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $currmonthday = $currmonth. "-01";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $lmonth = $month - 1;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if($lmonth == 0)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            $lmonth = 12;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $curryear = $curryear-1;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        $lastmonth =$curryear."-".$lmonth."-01";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $weekday = date("Y-m-d", (strtotime($currdate)-($week*60*60*24)));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $lweekday = date("Y-m-d", (strtotime($weekday)-(7*60*60*24)));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $filepathquery_curr = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter where ddate='%s' and did='%d'", $this->database->getEscaped($currdate), (int) $did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $count_curr_dt  = $this->database->resultQuery($filepathquery_curr);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $filepathquery_yes = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter where ddate='%s' and did='%d'", $this->database->getEscaped($yesterday), (int) $did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $count_yes_dt  = $this->database->resultQuery($filepathquery_yes);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $filepathquery_cw = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter where ddate>'%s' and did='%d'", $this->database->getEscaped($weekday), (int) $did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $count_cw_dt  = $this->database->resultQuery($filepathquery_cw);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $filepathquery_lw = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter where ddate<='%s' and ddate>'%s' and did='%d'", $this->database->getEscaped($weekday), $this->database->getEscaped($lweekday), (int) $did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $count_lw_dt  = $this->database->resultQuery($filepathquery_lw);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $filepathquery_cm = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter where ddate>='%s' and did='%d'", $this->database->getEscaped($currmonthday), (int) $did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $count_cm_dt  = $this->database->resultQuery($filepathquery_cm);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $filepathquery_lm = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter where ddate>='%s' and ddate<'%s' and did='%d'", $this->database->getEscaped($lastmonth), $this->database->getEscaped($currmonthday), (int) $did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $count_lm_dt  = $this->database->resultQuery($filepathquery_lm);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $filepathquery_tot = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter where did='%d'", (int) $did);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $count_tot_dt  = $this->database->resultQuery($filepathquery_tot);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        return array(  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            "count_curr_dt" => $count_curr_dt,  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            "count_yes_dt" => $count_yes_dt,  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            "count_cw_dt" => $count_cw_dt,  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            "count_lw_dt" => $count_lw_dt,  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            "count_cm_dt" => $count_cm_dt,  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            "count_lm_dt" => $count_lm_dt,  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            "count_tot_dt" => $count_tot_dt);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    }

    function getAllExtensions() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $extensionquery = sprintf("SELECT * FROM #__extrawatch_dm_extension");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->database->objectListQuery($extensionquery);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function getAllFilePaths() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $filepathquery = sprintf("SELECT * FROM #__extrawatch_dm_paths where dname is not NULL and dname != ''");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->database->objectListQuery($filepathquery);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function getAllUsersAsIdToUsernameArray() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->env->getAllUsersAsIdToUsernameArray($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function getDownloadLog() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        SELECT ddate, downloadLog.ip AS ip, referrerId, downloadLog.timestamp, dname, allowedReferrer, referrerURL, downloadLog.userId FROM (
          SELECT ddate, #__extrawatch_dm_counter.ip AS ip, referrerId, timestamp, dname, allowedReferrer, #__extrawatch_dm_referrer.referrer AS referrerURL, #__extrawatch_dm_counter.userId AS userId
            FROM `#__extrawatch_dm_counter`
            JOIN #__extrawatch_dm_paths ON #__extrawatch_dm_paths.did = #__extrawatch_dm_counter.did
            LEFT JOIN #__extrawatch_dm_referrer ON #__extrawatch_dm_counter.referrerId = #__extrawatch_dm_referrer.id
            ORDER BY #__extrawatch_dm_counter.id DESC LIMIT 100
          ) AS downloadLog
         LEFT JOIN #__extrawatch_user_log ON #__extrawatch_user_log.userId = downloadLog.userId
        ");
        return $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }


    function findOrAddReferrer($referrer)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $referrer = ExtraWatchHelper::htmlspecialchars(ExtraWatchInput::validate(_EW_INPUT_REFERRER,$referrer));   ///

        $id = $this->getReferrerIdByName($referrer);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        if (!@$id) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $query = sprintf("insert into #__extrawatch_dm_referrer (referrer) values ('%s') ", $this->database->getEscaped($referrer));
            $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $id = $this->getReferrerIdByName($referrer);;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        return $id;
    }

    private function getReferrerIdByName($referrer)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        $query = sprintf("select id from #__extrawatch_dm_referrer where (`referrer` = '%s') limit 1 ", $this->database->getEscaped($referrer));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->database->resultQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

	 function getDownloadLogForIPBetweenTimestamps($ip, $earlierTimestamp, $laterTimestamp) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("SELECT * FROM  `#__extrawatch_dm_counter` JOIN #__extrawatch_dm_paths ON #__extrawatch_dm_paths.did = #__extrawatch_dm_counter.did where ip = '%s' and (%d > `timestamp`) and (`timestamp` > %d)  ORDER BY #__extrawatch_dm_counter.id DESC ", $this->database->getEscaped($ip), (int) $earlierTimestamp, (int) $laterTimestamp);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		return $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
	}

    function getDownloadLogForIPBetweenTimestampsFromRef($downloadLog, $rowNumber, $ip, $earlierTimestamp, $laterTimestamp) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		$downloadsForIpBetweenTimestamps = array();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (@$downloadLog)
		foreach($downloadLog as $log) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

		if (
            ($rowNumber == 1 && $log->ip == $ip && $log->timestamp >= $earlierTimestamp) || //this is is for first visit if the download was after the very first visit timestamp  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            ($log->ip == $ip && $earlierTimestamp >= $log->timestamp && $log->timestamp >= $laterTimestamp)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
         ) {
					$download = array();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
					$download['timestamp'] = $log->timestamp;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
					$download['dname'] = $log->dname;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
					$downloadsForIpBetweenTimestamps[] = $download;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
			}
		}
		return $downloadsForIpBetweenTimestamps;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
	
	
    function getDownloadLogIpTimestampPath() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $query = sprintf("SELECT dname, ip, timestamp FROM  `#__extrawatch_dm_counter` JOIN #__extrawatch_dm_paths ON #__extrawatch_dm_paths.did = #__extrawatch_dm_counter.did  ORDER BY #__extrawatch_dm_counter.id DESC limit 20");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }


    /**
     * Thanks to stackoverflow.com http://stackoverflow.com/questions/3697748/fastest-way-to-serve-a-file-using-php  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
     * @param $path
     * @param null $speed  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
     * @param bool $multipart  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
     * @return bool
     */
    function serveDownload($path, $speed = null, $mimeType, $multipart = true)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        while (ob_get_level() > 0)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            ob_end_clean();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        ob_clean(); // cleans any potential warning messages, etc.

        if (is_file($path = realpath($path)) === true)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        {
            $file = @fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_EXTERNAL_PATH,$path), 'rb');   ///**
            $size = sprintf('%u', filesize($path));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $speed = (empty($speed) === true) ? 1024 : floatval($speed);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            if (is_resource($file) === true)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            {
                set_time_limit(0);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                if (strlen(session_id()) > 0)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    session_write_close();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }

                if ($multipart === true)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    $range = array(0, $size - 1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    if (array_key_exists('HTTP_RANGE', $_SERVER) === true)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        $range = array_map('intval', explode('-', preg_replace('~.*=([^,]*).*~', '$1', $_SERVER['HTTP_RANGE'])));  	 ///

                        if (empty($range[1]) === true)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            $range[1] = $size - 1;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

						if (@$range)
                        foreach ($range as $key => $value)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            $range[$key] = max(0, min($value, $size - 1));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                        if (($range[0] > 0) || ($range[1] < ($size - 1)))  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                            header(sprintf('%s %03u %s', 'HTTP/1.1', 206, 'Partial Content'), true, 206);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                        }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    }  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                    header('Accept-Ranges: bytes');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                    header('Content-Range: bytes ' . sprintf('%u-%u/%u', $range[0], $range[1], $size));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }

                else  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    $range = array(0, $size - 1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                }

                header('Pragma: public');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                header('Cache-Control: public, no-cache');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                header('Content-Type: '.$mimeType);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                header('Content-Length: ' . sprintf('%u', $range[1] - $range[0] + 1));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                header('Content-Disposition: filename="' . basename($path) . '"');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                header('Content-Transfer-Encoding: binary');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

                if ($range[0] > 0)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    fseek($file, (int) $range[0]);  ///
                }

                while ((feof($file) !== true) && (connection_status() === CONNECTION_NORMAL))  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                {
                    echo fread($file, round($speed * 1024)); flush();  ///
                }

                fclose($file);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }

            exit();
        }

        else
        {
            header(sprintf('%s %03u %s', 'HTTP/1.1', 404, 'Not Found'), true, 404);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }

        return false;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function getDataCount() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $query = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter ");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return (int) $this->database->resultQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }


    function mime_content_type($filename) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $mime_types = array(  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            'txt' => 'text/plain',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'htm' => 'text/html',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'html' => 'text/html',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'php' => 'text/html',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'css' => 'text/css',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'js' => 'application/javascript',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'json' => 'application/json',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'xml' => 'application/xml',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'swf' => 'application/x-shockwave-flash',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'flv' => 'video/x-flv',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            // images  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'png' => 'image/png',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'jpe' => 'image/jpeg',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'jpeg' => 'image/jpeg',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'jpg' => 'image/jpeg',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'gif' => 'image/gif',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'bmp' => 'image/bmp',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'ico' => 'image/vnd.microsoft.icon',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'tiff' => 'image/tiff',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'tif' => 'image/tiff',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'svg' => 'image/svg+xml',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'svgz' => 'image/svg+xml',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            // archives  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'zip' => 'application/zip',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'rar' => 'application/x-rar-compressed',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'exe' => 'application/x-msdownload',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'msi' => 'application/x-msdownload',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'cab' => 'application/vnd.ms-cab-compressed',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            // audio/video  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'mp3' => 'audio/mpeg',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'qt' => 'video/quicktime',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'mov' => 'video/quicktime',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            // adobe  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'pdf' => 'application/pdf',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'psd' => 'image/vnd.adobe.photoshop',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'ai' => 'application/postscript',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'eps' => 'application/postscript',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'ps' => 'application/postscript',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            // ms office  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'doc' => 'application/msword',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'rtf' => 'application/rtf',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'xls' => 'application/vnd.ms-excel',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'ppt' => 'application/vnd.ms-powerpoint',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

            // open office  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'odt' => 'application/vnd.oasis.opendocument.text',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            'ods' => 'application/vnd.oasis.opendocument.spreadsheet',  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        );

        $ext = strtolower(array_pop(explode('.',$filename)));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (array_key_exists($ext, $mime_types)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            return $mime_types[$ext];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        elseif (function_exists('finfo_open')) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $finfo = finfo_open(FILEINFO_MIME);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $mimetype = finfo_file($finfo, $filename);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            finfo_close($finfo);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            return $mimetype;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        else {
            return 'application/octet-stream';  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
    }

    /**
     * @param $root_file  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
     * @param $writingonht  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
     */
    public function writeToFile($root_file, $writingonht)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        if (file_exists($root_file)) {  	 ///
            if (is_writable($root_file)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file), "w");///
                fwrite($handle, $writingonht);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            } else {
                echo _EW_DOWNLOADS_HTACCESS_NOT_WRITABLE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        } else {
            $handle = fopen(ExtraWatchInput::validate(_EW_INPUT_FILE_ROOT_PATH_HTACCESS,$root_file), "w");///
            if ($handle) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
                fwrite($handle, $writingonht);   ///
                fclose($handle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            } else {
                echo _EW_DOWNLOADS_HTACCESS_COULD_NOT_BE_CREATED;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            }
        }
    }

    function objectListToString($objectListResults, $separator) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (@$objectListResults)
		foreach($objectListResults as $objectListResult) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $pathsArray[] = $objectListResult->dname;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        return implode($pathsArray, $separator);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    function getDownloadCountForDay($date) {
        $filepathquery_curr = sprintf("SELECT COUNT(*) FROM #__extrawatch_dm_counter where ddate='%s' ", $this->database->getEscaped($date));
        return $this->database->resultQuery($filepathquery_curr);

    }

    function checkIfExtensionAllowed($extension) {
        $extensionquery = sprintf("select count(*) from #__extrawatch_dm_extension where extname='%s'", $this->database->getEscaped($extension));
        $this->database->setQuery($extensionquery);
        return $this->database->loadResult();

    }

    /**
     * @param $file
     * @param $filepathid
     * @param $currdate
     * @param $ip
     * @param $referrerId
     * @param $timestamp
     */
    public function increaseDownloadStat($file)
    {
        $ip = ExtraWatchInput::validate(_EW_INPUT_IP, ExtraWatchVisit::getRemoteIPAddress()); ///
        $referrer = ExtraWatchInput::validate(_EW_INPUT_REFERRER, ExtraWatchVisit::getReferer()); ///

        $currdate = date("Y-m-d");
        $referrerId = $this->findOrAddReferrer($referrer);
        $timestamp = $this->date->getUTCTimestamp();

        $userId = @$this->env->getUserId();

        $filepathquery = sprintf("SELECT did FROM #__extrawatch_dm_paths where dname='%s'", $this->database->getEscaped($file));
        $filepathid = $this->database->resultQuery($filepathquery);

        $filesearchquery = sprintf("SELECT COUNT(*) as `count` FROM #__extrawatch_dm_paths where dname='%s'", $this->database->getEscaped($file));
        $filesearchar = $this->database->resultQuery($filesearchquery);


        if ($this->checkIfRequestedAgainByAjaxReferer()) {
            return;
        }


        if ($filesearchar > 0) {
            $filepathquery_add = sprintf("insert into #__extrawatch_dm_counter (did,ddate,ip,referrerId,`timestamp`, userId) values ('%s','%s','%s','%d','%d','%d')", (int)$filepathid, $this->database->getEscaped($currdate), $ip, (int)$referrerId, (int)$timestamp, (int)$userId);
            $this->database->executeQuery($filepathquery_add);
        } else {
            $file_add = sprintf("insert into #__extrawatch_dm_paths (dname) values ('%s')", $this->database->getEscaped($file));
            $this->database->executeQuery($file_add);

            $path_query = "select did from #__extrawatch_dm_paths where dname = ('$file')";
            $filepathid = $this->database->resultQuery($path_query);

            $counter_add = sprintf("insert into #__extrawatch_dm_counter (did,ddate,ip,referrerId, `timestamp`, userId) values ('%d','%s','%s','%d','%d','%d')", (int)$filepathid, $this->database->getEscaped($currdate), $ip, (int)$referrerId, (int)$timestamp, (int) $userId);
            $this->database->executeQuery($counter_add);
        }

    }


    function checkIfRequestedAgainByAjaxReferer() {
        if (@strstr($_SERVER['HTTP_REFERER'], self::EW_DOWNLOAD_URL_PART)) {
            return TRUE;
        }
    }

    function findTopDownloads() {
        $chartquery = sprintf(self::DOWNLOADS_QUERY, "", (int) $this->getChartsDownloadsLimit());
        $chartar = $this->database->objectListQuery($chartquery);
        return $chartar;
    }

    function findChartValuesFilteredByDates($graphDayStartISOFormat, $graphDayEndISOFormat) {

        $condition = sprintf(" where ddate > '%s' and ddate < '%s' ",
            $this->database->getEscaped($graphDayStartISOFormat),
            $this->database->getEscaped($graphDayEndISOFormat));

        $filepathquery_tot = sprintf(self::DOWNLOADS_QUERY, $condition, (int) $this->getChartsDownloadsLimit());
        $count_tot_dt = $this->database->objectListQuery($filepathquery_tot);
        return $count_tot_dt;
    }

    function findChartValuesFilteredByDate($pday) {

        $condition = sprintf(" where ddate = '%s' ", $this->database->getEscaped($pday));

        $filepathquery_tot = sprintf(
            self::DOWNLOADS_QUERY, $condition, (int) $this->getChartsDownloadsLimit());

        $count_tot_dt = $this->database->objectListQuery($filepathquery_tot);
        return $count_tot_dt;
    }

    public function getChartsDownloadsLimit() {
        return (int) $this->chartsDownloadsLimit;
    }





}


