<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @package ExtraWatch  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @version 2.3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @revision 2663  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @copyright (C) 2016 by CodeGravity.com - All rights reserved!  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @website http://www.extrawatch.com  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 */

defined('_JEXEC') or die('Restricted access');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

class ExtraWatchConfig  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
{

  public $database;
  public $liveSiteCached;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  public $env;
  public static $configValuesCached;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

  const _EW_REQUEST_ORIGIN_FRONTEND = "frontend";
  const _EW_REQUEST_ORIGIN_BACKEND = "backend";
  const _EW_REQUEST_ORIGIN_PARAM_NAME = "origin";

  const _EW_TOKEN_PARAM_NAME = "ewToken";

  function __construct($database)
  {
    $this->env = ExtraWatchEnvFactory::getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->database = $database;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function getAdminitratorDirectoryName()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    return $this->env->getAdminDir();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function getJavascriptDirectoryName()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    return "components/com_extrawatch/js";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  /**
   * config
   */
  function checkBackendTokenFromUrl()
  {
      $token = $this->getTokenFromRequestUrl();
      if (!$this->isPermittedWithBackendToken($token)) {
          die("Access denied");
    }
  }

  function isPermittedWithBackendToken($backendToken)
  {
      return (ExtraWatchConfig::getBackendToken() === $backendToken);
  }


  /**
   * config
   *
   * @return unknown  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   */
  function getBackendToken()
  {
    $rand = $this->getConfigValue("rand");
    return sha1($rand.gmdate("d w"));

  }

  /**
   * config
   */
  function isIgnored($name, $key)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    if (!@$key) {
      return FALSE;
    }
    $name = strtoupper($name);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
	$rowValue = $this->getConfigValue($this->database->getEscaped("EXTRAWATCH_IGNORE_" . $name));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    //$query = sprintf("select value from #__extrawatch_config where name='%s' limit 1", $this->database->getEscaped("EXTRAWATCH_IGNORE_" . $name));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    //$rowValue = $this->database->resultQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $exploded = explode("\n", $rowValue);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    foreach ($exploded as $value) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      if (ExtraWatchHelper::wildcardSearch(trim($value), $key)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        return TRUE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      }
    }
    return FALSE;
  }


  /**
   * config
   */
  function updateHelperCountByKey($key, $value)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $count = $this->getCountByKey($key);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    if (@ $count) {
      $query = sprintf("update #__extrawatch_config set value = '%s' where (name = '%s' and date = '%d')", $this->database->getEscaped($value), $this->database->getEscaped($key), (int) $value);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    } else {
      $query = sprintf("insert into #__extrawatch_config (`name`, `value`) values ('%s', '%s')", $this->database->getEscaped($key), $this->database->getEscaped($value));
      $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
  }

  function reloadConfigValues() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $query = sprintf("select name, value from #__extrawatch_config order by value");
      $values = $this->database->objectListQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      if ($values)
      foreach($values as $keyAssoc => $valueAssoc) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          ExtraWatchConfig::$configValuesCached[$valueAssoc->name] = $valueAssoc->value;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      }
  }

  /**
   * config
   */

  function getConfigValue($key)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {

  	if (ExtraWatchConfig::$configValuesCached == NULL) {	//caching of config values  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->reloadConfigValues();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		$value = @ExtraWatchConfig::$configValuesCached[$key];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
	} else {
			$value = @ExtraWatchConfig::$configValuesCached[$key];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		}
    // explicit off for checkboxes  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    if ($value == "Off") {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return FALSE;
    }
    if ($value) {
      return addslashes($value);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    $value = @ constant($key);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    return $value;
  }


  /**
   * config
   */
  function saveConfigValue($key, $value)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $query = sprintf("select count(name) as count from #__extrawatch_config where name = '%s' limit 1", $this->database->getEscaped($key));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $count = $this->database->resultQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    if ($count) { //update  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $query = sprintf("update #__extrawatch_config set value = '%s' where name = '%s'", $this->database->getEscaped($value), $this->database->getEscaped($key));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    } else { //insert  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $query = sprintf("insert into #__extrawatch_config (`name`,`value`) values ('%s','%s')", $this->database->getEscaped($key), $this->database->getEscaped($value));
      $this->database->executeQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
    $this->reloadConfigValues();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  /**
   * config
   */
  function removeConfigValue($key, $value)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $query = sprintf("delete IGNORE from #__extrawatch_config where name = '%s' limit 1", $this->database->getEscaped($key));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $count = $this->database->resultQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  /**
   * config
   */
  function getLanguage()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $language = $this->getConfigValue("EXTRAWATCH_LANGUAGE");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    return $language;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  /**
   * config
   */
  function checkLicenseAccepted()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $accepted = $this->getConfigValue("EXTRAWATCH_LICENSE_ACCEPTED");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    if (@ $accepted) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return TRUE;
    }
    return FALSE;
  }

  function getLicenseFilePath()  	 //TODO obsolete
  {
    $config = new JConfig();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $fileName = md5($this->getLiveSite());  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    return $config->tmp_path . DS . $fileName . ".tmp";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  /* function createLicenseFile() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $result = 0;
      if (!file_exists($this->getLicenseFilePath())) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          $ourFileHandle = fopen($this->getLicenseFilePath(), 'w') or die("can't write to temp directory: ".$config->tmp_path);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          $result = fwrite($ourFileHandle, ExtraWatchHelper::getServerTime());  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          fclose($ourFileHandle);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      }
      return $result;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }*/

  function useTrial()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    if (!$this->isTrial()) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $this->saveConfigValue("EXTRAWATCH_TRIAL_TIME", ExtraWatchDate::getUTCTimestamp());  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
  }

  function isTrial()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    if ($this->getConfigValue("EXTRAWATCH_TRIAL_TIME")) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return TRUE;
    }
    return FALSE;
  }

  function isTrialTimeOver()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    return (!($this->getTrialVersionTimeLeft() > 0));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  /**
   * config
   */
  function setLicenseAccepted()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    // $this->createLicenseFile(); not used yet  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->saveConfigValue("EXTRAWATCH_LICENSE_ACCEPTED", "1");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  /**
   * config
   */
  function setLiveSite($liveSite)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    if (@$liveSite) {
        $this->saveConfigValue("EXTRAWATCH_LIVE_SITE", "$liveSite");
    }
  }

  /**
   * config
   */
  function getCheckboxValue($key)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $setting = $this->getConfigValue($key);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    return $this->getCheckboxBooleanValue($setting);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

    /**
     * config
     */
    function getCheckboxBooleanValue($value)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
        if ($value == '1' || strtolower($value) == 'on') {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            return TRUE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        }
        return FALSE;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }


    /**
   * If on HTTPS site, use the https links  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   * @param  $originalLink  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   * @return mixed
   */
  static function replaceHttpByHttps($originalLink)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $env = ExtraWatchEnvFactory::getEnvironment();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    if ($env->isSSL()) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return str_ireplace("http://", "https://", $originalLink);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
    return str_ireplace("https://", "http://", $originalLink);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function getLiveSite()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    if ($this->liveSiteCached) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return $this->liveSiteCached;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
    if (!defined('EXTRAWATCH_LIVE_SITE')) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $liveSite = ExtraWatchConfig::replaceHttpByHttps($this->getConfigValue('EXTRAWATCH_LIVE_SITE'));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $this->liveSiteCached = $liveSite;
      return $liveSite;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    } else {
      $liveSite = ExtraWatchConfig::replaceHttpByHttps(rtrim(constant('EXTRAWATCH_LIVE_SITE')));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      $this->liveSiteCached = $liveSite;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return $liveSite;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
  }

  function checkIfLiveSiteMatches()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    //TODO
  }

  //TODO
  function getAdministratorPath()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    //TODO -> should be changed, there can be other directory  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    return $this->getLiveSite() . $this->getAdminitratorDirectoryName() . "/";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function getAdministratorIndex()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    //TODO -> should be changed, there can be other directory  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    return $this->getLiveSite() . $this->getAdminitratorDirectoryName() . "/index.php";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }


  function cleanUrl($domain)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $domain = str_replace("http://", "", $domain);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $domain = str_replace("https://", "", $domain);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $domain = str_replace("www.", "", $domain);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    return $domain;
  }

  /**
   * Validate whether string is an IP address  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   * @param  $string  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   * @return bool
   */
  static function isIPAddress($string)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $regexp = '/^((1?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(1?\d{1,2}|2[0-4]\d|25[0-5])$/';  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    if (preg_match($regexp, $string)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return TRUE;
    }
    return FALSE;
  }


  function getProjectUrlByUsername($user) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      if (@_EW_CLOUD_MODE) {
        return $this->getDomainFromLiveSiteByUsername($user);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      } else {
         return "";
      }
  }


    function getDomainFromLiveSiteByUsername($user)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
       $query = sprintf("select `url`  from global_extrawatch_project where `id` = '%s' limit 1", $this->database->getEscaped($user));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
       $url = $this->database->resultQuery($query);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $parsedUrl = @ parse_url($url);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
		$scheme = @$parsedUrl['scheme'] ? @$parsedUrl['scheme']."://" : "http://";
        return $scheme.@$parsedUrl['host'];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    }
	
  function getDomainFromLiveSite($user)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {

      if (@_EW_CLOUD_MODE) {
          $domainWithSubdomain = $this->getDomainFromLiveSiteByUsername($user);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

      } else  {
          $parsedUrl = @ parse_url(@$_SERVER['HTTP_HOST']);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   		  $domainWithSubdomain = trim($this->cleanUrl(@$parsedUrl[path]));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      }
  

      if (!$domainWithSubdomain) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
          return "localhost";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      }

      /* if it's an IP address */  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    if ($this->isIPAddress($domainWithSubdomain)) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return $domainWithSubdomain;  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    /** should extract only domain, not subdomain */  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    //        preg_match('/^((.+)\.)?([A-Za-z][0-9A-Za-z\-]{1,63})\.(co\.uk|me\.uk|org\.uk|com|org|net|int|eu)(\/.*)?$/', $domainWithSubdomain, $matches);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    //        return @$matches[0];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    $splittedDomain = explode(".", $domainWithSubdomain);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $size = sizeof($splittedDomain);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

    if ($size <= 1) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return $splittedDomain[0]; // if it's localhost or just some hostname  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

    // by Eman Borg:  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    // co.uk, com.br, com.pl fix:  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    // if middle domain name is less than 3 chars, we assume it's 1st level domain,  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    if (($size > 2) && strlen($splittedDomain[$size - 2]) <= 3) {
      return $splittedDomain[$size - 3] . "." . $splittedDomain[$size - 2] . "." . $splittedDomain[$size - 1];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
    else {
      return $splittedDomain[$size - 2] . "." . $splittedDomain[$size - 1];  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
  }


  /**
   * config
   */
    function isAdFree()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    {
		if (@$this->getConfigValue("EXTRAWATCH_MARKETPLACE")) {
			return TRUE;
		}
	
        $domain = @$this->getDomainFromLiveSite(_EW_PROJECT_ID);$key = md5(strrev($domain));

        if ($key == @$this->getConfigValue("EXTRAWATCH_ADFREE")) {
            return TRUE;
        } else if ($key == @$this->getConfigValue("EXTRAWATCH_ADFREE_".$domain)){
            return TRUE;
        }

        return FALSE;
        /*require_once(JPATH_BASE2.DS."components".DS."com_extrawatch".DS."lib".DS."phpseclib".DS."Crypt".DS."RSA.php");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        require_once(JPATH_BASE2.DS."components".DS."com_extrawatch".DS."lib".DS."phpseclib".DS."Math".DS."BigInteger.php");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $rsa = new Crypt_RSA();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rsa->setEncryptionMode(CRYPT_RSA_ENCRYPTION_PKCS1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        $pk = file_get_contents(JPATH_BASE2.DS."components".DS."com_extrawatch".DS."lib".DS."phpseclib".DS."index.php");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rsa = new Crypt_RSA();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rsa->loadKey($pk);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $rsa->setEncryptionMode(CRYPT_RSA_ENCRYPTION_PKCS1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        return md5($this->getDomainFromLiveSite(_EW_PROJECT_ID)) == $rsa->decrypt(base64_decode($this->getConfigValue("EXTRAWATCH_ADFREE")));  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

        */
    }
	
	function isUnregistered() {
        $domain = $this->getDomainFromLiveSite(_EW_PROJECT_ID);
		return FALSE;
	}

  /**
   * config
   */
  function isFree()
  {
    if ($this->getConfigValue("EXTRAWATCH_FREE")) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return TRUE;
    }
    return FALSE;
  }

  /**
   * config
   */
  function activate($value)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    if (@$value) {
        $domain = $this->getDomainFromLiveSite(_EW_PROJECT_ID);
        $this->saveConfigValue('EXTRAWATCH_ADFREE_'.$domain, $this->database->getEscaped($value), true);
    } else {
        ExtraWatchLog::error("License activation value is empty!");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
    $this->saveConfigValue('EXTRAWATCH_FRONTEND_HIDE_LOGO', "on");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->saveConfigValue('EXTRAWATCH_FRONTEND_NOFOLLOW', "on");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->saveConfigValue('EXTRAWATCH_FRONTEND_NO_BACKLINK', "on");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    if ($this->isAdFree()) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      //echo("<span style='color: green'>" . _EW_CONFIG_LICENSE_ACTIVATED . "</span>");
      $ip = ExtraWatchVisit::getRemoteIPAddress();
	  $market = @$this->getConfigValue("EXTRAWATCH_MARKETPLACE");
	  echo("<iframe style='display:none' src='http://www.extrawatch.com/track/extrawatch/2.3/install/?domain=".$domain."&license=FREE&version=2.3.2663&ip=".$ip."&env=".get_class($this->env)."&key=".$value."&market=".@$market."' width='1px' frameborder='0' height='1px'>
        </iframe>");			
      $this->saveConfigValue('EXTRAWATCH_FREE', 0);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    } else if (!$this->isUnregistered()){  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      echo("<span style='color: red'>" . _EW_CONFIG_LICENCE_DONT_MATCH . "</span>");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }

  }


  /**
   * config
   */
  function useFreeVersion()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $this->saveConfigValue('EXTRAWATCH_FREE', (int)1);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  /**
   * Important when doing an upgrade to data between versions, we need to know to which version these data belong  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   * @return void
   */
  function saveVersionIntoDatabase()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    $this->saveConfigValue('EXTRAWATCH_VERSION', EXTRAWATCH_VERSION);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }


  function checkLiveSite()
  {
    if ($this->getLiveSite() == $this->env->getRootSite()) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      return TRUE;
    }
    return FALSE;
  }

  function getTrialVersionTimeLeft()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    return (int)(16 - ((ExtraWatchDate::getUTCTimestamp() - $this->getConfigValue("EXTRAWATCH_TRIAL_TIME")) / 3600 / 24) - 0.01); //because it will display 15 days as time left  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function getLiveSiteWithSuffix()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    if (@_EW_CLOUD_MODE) {
      return _EW_SCRIPT_HOST._EW_SCRIPT_HOST_DIR . $this->env->getEnvironmentSuffix();
    } else {
        //die("Live Site With Suffix: ".$this->getLiveSite() . $this->env->getEnvironmentSuffix());
        return $this->getLiveSite() . $this->env->getEnvironmentSuffix();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    }
  }

  function renderLink($task = "", $otherParams = "")  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    return $this->env->renderLink($task, $otherParams);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function getEnvironment()  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {
    return get_class($this->env);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

  function getFrontendToken()
  {
    return sha1(sha1(gmdate("d w")).sha1($this->getConfigValue("rand")));
  }

  function getHeatmapToken()
  {
    return sha1(gmdate("d w").sha1(sha1($this->getConfigValue("rand"))));
  }

    /**
   * For things like heatmap etc..  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   * @return bool
   */
  function isPermittedWithFrontendToken($frontendToken)
  {
    return (ExtraWatchConfig::getFrontendToken() === $frontendToken);
  }

    function isPermittedWithHeatmapToken($heatmapToken)
    {
        return (ExtraWatchConfig::getHeatmapToken() === $heatmapToken);
    }

    /**
   * Used by both - save anti-spam and save settings  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   * @param  $checkboxNamesArray  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
   * @param  $post
   * @return void
   */
  function saveConfigValues($checkboxNamesArray, $post)  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  {

    if (@$post)
    foreach ($post as $key => $value) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      if (strstr($key, "EXTRAWATCH_")) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->saveConfigValue( ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, $key), trim($value));
      }
    }
    //hack :( explicitly save checkbox values  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    foreach (@$checkboxNamesArray as $key => $value) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      if (@ !$post[$value]) { //if there is no value - checkbox unchecked  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        $this->saveConfigValue($value, "Off");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
      }
    }
    // explicitly reset chache because of frontend settings  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    ExtraWatchCache::clearCache($this->database);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
    $this->reloadConfigValues();  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
  }

    function initializeTranslations() {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
        if (!defined("_EW_MENU_STATS")) {  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            $modulePath = realpath(dirname(__FILE__).DIRECTORY_SEPARATOR."..");  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
            require $modulePath . DS . "lang" . DS . ExtraWatchInput::validate(_EW_INPUT_LANGUAGE,$this->getLanguage()) . ".php";  	///
        }
    }
	
	function setHtAccessPermissions() {

		if (@get_class($this->env) == "ExtraWatchMagentoEnv")  {
			$magentoAppHtAccessPath = realpath(dirname(__FILE__).DS."..".DS."..".DS."..".DS."..".DS."..".DS."..".DS."..".DS."..").DS.".htaccess";
			$moduleAppHtAccessPath = realpath(dirname(__FILE__).DS."env".DS."magento".DS."module".DS."app".DS.".htaccess");
			@copy($moduleAppHtAccessPath, $magentoAppHtAccessPath);
		}
		
	}

    /**
     * @param $this
     */
    function saveRandValue()
    {
        $rand = $this->getConfigValue('rand');
        if (!$rand) {
            $this->saveConfigValue('rand', sha1(sha1(mt_rand()) + mt_rand()));
        }
    }

    public function getBackendRequestOriginUrlParam() {
        return self::_EW_REQUEST_ORIGIN_PARAM_NAME."=".ExtraWatchConfig::_EW_REQUEST_ORIGIN_BACKEND;
    }

    public function getFrontendRequestOriginUrlParam() {
        return self::_EW_REQUEST_ORIGIN_PARAM_NAME."=".ExtraWatchConfig::_EW_REQUEST_ORIGIN_FRONTEND;
    }

    public function getTokenUrlParam($token) {
        return self::_EW_TOKEN_PARAM_NAME."=".$token;
    }


    /**
     * @param $queryParams
     * @param $extraWatch
     */
    function validateRequestToken($queryParams)
    {
        $origin = ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, @$queryParams[ExtraWatchConfig::_EW_REQUEST_ORIGIN_PARAM_NAME]); ///
        $token = $this->getTokenFromRequestUrl();
        if ($origin == ExtraWatchConfig::_EW_REQUEST_ORIGIN_FRONTEND) {
            if (!$this->isPermittedWithFrontendToken($token)) {
                die("Unauthorized frontend access without security token");
            }
        } else if ($origin == ExtraWatchConfig::_EW_REQUEST_ORIGIN_BACKEND) {
            if (!$this->isPermittedWithBackendToken($token)) {
                die("Unauthorized backend access without security token");
            }
        } else {
            die("Unauthorized access without security token");
        }
    }

    /**
     * @return string
     */
    public function getTokenFromRequestUrl()
    {
        $queryParams = ExtraWatchHelper::getUrlQueryParams();
        $token = ExtraWatchInput::validate(_EW_INPUT_ONE_STRING, @$queryParams[ExtraWatchConfig::_EW_TOKEN_PARAM_NAME]);///
        return $token;
    }
}


