<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @package ExtraWatch  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @version 2.3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @revision 2663  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @copyright (C) 2016 by CodeGravity.com - All rights reserved!  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 * @website http://www.codegravity.com  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
 */

defined('_JEXEC') or die('Restricted access');  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

/*define('DS', DIRECTORY_SEPARATOR);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
$jBasePath = realpath(dirname(__FILE__) . DS . ".." . DS . ".." . DS . "..". DS);  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
define('JPATH_BASE2', $jBasePath);*/  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  

header("Content-type: text/xml");

function renderMarker($city, $country, $ipAddress, $latitude, $longitude, $type='visitor') {
    $output = "
    <marker
    city=\"$city\"
    country=\"$country\"
    address=\"$ipAddress\"
    lat=\"$latitude\"
    lng=\"$longitude\"
    type=\"$type\"/>";
    return $output;
}

include_once JPATH_BASE2 . DS . "components" . DS . "com_extrawatch" . DS. "includes.php";  	 	    	    		  	 	  	 	  		 	 		    	 			 	   		  	 	 		 	 	   	      	  	 		 		 				 			 		  		    	 		 		  
$extraWatch = new ExtraWatchMain();
$extraWatch->helper->setNoindexHttpHeaders();   //setting explicitly for ajax requests
$extraWatch->block->checkBackendTokenFromUrl();

$ips = $extraWatch->visit->getLastActiveIpsWithLatLong();

$markerOutput = "";
$markerOutput .= "<!--";
$markerOutput .= var_export($ips, true);
$markerOutput .= "-->";


if (@$ips)
foreach($ips as $ip) {
    $location = "";
    if (!$ip->latitude && !$ip->longitude) {
        $location = $extraWatch->visit->ip2Location($ip->ip);
        $latitude = $location['latitude'];
        $longitude = $location['longitude'];
        $city = $location['city'];
        $extraWatch->visit->updateLatLongCityForIp($ip->ip, $latitude, $longitude, $city);

    } else {
        $latitude = $ip->latitude;
        $longitude = $ip->longitude;
        $city = $ip->city;
    }
    $markerOutput .= renderMarker(@$city,
        @$location['country'],
        @$ip->ip,
        @$latitude,
        @$longitude);
}
?>

<markers>
  <?php echo $markerOutput; ?>
</markers>
